#version 430 core
layout (location = 0) in vec3 position;

layout (location = 0) out vec2 screenDirection;
layout (location = 1) out vec3 globalPos;


uniform mat4 worldTransform;
uniform vec3 worldPos;
uniform float size;

void main()
{

  gl_Position =  worldTransform * vec4(position * size + worldPos, 1.0f);

  screenDirection = vec4(worldTransform * vec4(position, 0.0f)).xy;
  globalPos = (position * size + worldPos);

}